var map;
var geocoder;
var infoWindow = new google.maps.InfoWindow();
var latlng = new google.maps.LatLng(0, 0);
var mapopts = {
  zoom: 14, //Default Zoom on Location
  zoomControl: false,  //Choose whether or not to display the zoom controls
  mapTypeControl: false, //Choose whether or not to display the map controls
  streetViewControl: false, //Choose whether or not to display the zoom controls
  center: latlng, //Choose Where the Map Centers
  mapTypeId: google.maps.MapTypeId.ROADMAP, //Map Type (ie Terrain, sattelite)
  scrollwheel: false, //Let the scroll wheel zoom the map in/out
  styles: [
    {
        "featureType": "all",
        "elementType": "labels.text.fill",
        "stylers": [
            {
                "saturation": 36
            },
            {
                "color": "#000000"
            },
            {
                "lightness": 40
            }
        ]
    },
    {
        "featureType": "all",
        "elementType": "labels.text.stroke",
        "stylers": [
            {
                "visibility": "on"
            },
            {
                "color": "#000000"
            },
            {
                "lightness": 16
            }
        ]
    },
    {
        "featureType": "all",
        "elementType": "labels.icon",
        "stylers": [
            {
                "visibility": "off"
            }
        ]
    },
    {
        "featureType": "administrative",
        "elementType": "geometry.fill",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 20
            }
        ]
    },
    {
        "featureType": "administrative",
        "elementType": "geometry.stroke",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 17
            },
            {
                "weight": 1.2
            }
        ]
    },
    {
        "featureType": "landscape",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 20
            }
        ]
    },
    {
        "featureType": "poi",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 21
            }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "geometry.fill",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 17
            }
        ]
    },
    {
        "featureType": "road.highway",
        "elementType": "geometry.stroke",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 29
            },
            {
                "weight": 0.2
            }
        ]
    },
    {
        "featureType": "road.arterial",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 18
            }
        ]
    },
    {
        "featureType": "road.local",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 16
            }
        ]
    },
    {
        "featureType": "transit",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 19
            }
        ]
    },
    {
        "featureType": "water",
        "elementType": "geometry",
        "stylers": [
            {
                "color": "#000000"
            },
            {
                "lightness": 17
            }
        ]
    }
],
        }
  map = new google.maps.Map(document.getElementById("map"), mapopts); //This is the id of the div where the map will be spat
  geocoder = new google.maps.Geocoder();
  geocoder.geocode({'address': address}, function(results, status) {
  if (status == google.maps.GeocoderStatus.OK) {
    map.setCenter(results[0].geometry.location);
     //var icon = 'media/images/map.svg'; //Location of custom cursor (Delete for default)
    var marker = new google.maps.Marker({
      map: map,
      icon: icon, 
      position: results[0].geometry.location
    });
    var circle = new google.maps.Circle({
      map: map,
      radius: 20000, //Radius (in Metres)
      fillColor: '#fff', //Colour of Radius Marker
      strokeColor: '#fff',
      strokeWeight: '0px',
      blurRadius: 100,
    });
    circle.bindTo('center', marker, "position");
    circle.blur();
  } 
});